var Main = function(game){

};

function getUrlVars(name) {
    name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
    var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
    results = regex.exec(location.search);
    return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}

var ID=getUrlVars("id");

console.log("el ID del usaurio es "+ID);

Main.prototype = {

	create: function() {

		var me = this;

		this.game.add.image(0,0,'fondo');
		this.game.add.image(0,0,'timer');
		timer = this.game.add.text(752, 156, '00seg' , {font: "40px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});
		ArcGis = this.game.add.text(756, 245 + (40 * 1), 'ArcGis' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		Capa  = this.game.add.text(756, 245 + (40 * 2), 'Capa ' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});
		Curva = this.game.add.text(756, 245 + (40 * 3), 'Curva' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		Dashboard = this.game.add.text(756, 245 + (40 * 4), 'Dashboard' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		EOS  = this.game.add.text(756, 245 + (40 * 5), 'EOS' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});
		Excalibur  = this.game.add.text(756, 245 + (40 * 6), 'Excalibur' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		Geogeeks  = this.game.add.text(756, 245 + (40 * 7), 'Geogeeks' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		Imagenes = this.game.add.text(756, 245 + (40 * 8), 'Imágenes' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});
		Indoors  = this.game.add.text(756, 245 + (40 * 9), 'Indoors' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});
		Insights  = this.game.add.text(756, 245 + (40 * 10), 'Insights' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		Mapa  = this.game.add.text(956, 245 + (40 * 1), 'Mapa' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		Poligono  = this.game.add.text(956, 245 + (40 * 2), 'Polígono' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		QuickCapture  = this.game.add.text(956, 245 + (40 * 3), 'QuickCapture ' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		SIG  = this.game.add.text(956, 245 + (40 * 4), 'SIG' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});
		StoryMap  = this.game.add.text(956, 245 + (40 * 5), 'StoryMap ' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		Trimble  = this.game.add.text(956, 245 + (40 * 6), 'Trimble' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		WebAppBuilder  = this.game.add.text(956, 245 + (40 * 7), 'WebAppBuilder' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});
		Workforce  = this.game.add.text(956, 245 + (40 * 8), 'Workforce' , {font: "30px Arial", fill: "#ffffff", stroke: "#ffffff", strokeThickness: 0});

		this.wordArray = [ArcGis, QuickCapture, Excalibur, Insights, Dashboard, Indoors, Workforce, Capa, Curva, Poligono, Mapa, WebAppBuilder, Geogeeks, SIG, Imagenes, Trimble, EOS, StoryMap ]

		me.guessing = false;
		me.currentWord = [];
		me.correctWords = [];

		//Keep track of the users score
		me.score = 0;
		me.scoreBuffer = 0;

		//Keep track fo the round time
		me.remainingTime = 12000;
		me.fullTime = 12000;

		//me.remainingTime = 200;
		//me.fullTime = 200;

		//Declare assets that will be used as tiles
		me.tileLetters = [
			'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k',
			'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
			'w', 'x', 'y', 'z'
		];

		//What colours will be used for our tiles?
		me.tileColors = [
			'#56b2e3'
		];

		//Set the width and height for the tiles
		me.tileWidth = 40;
		me.tileHeight = 40;

		//A buffer for how much of the tile activates a select
		me.selectBuffer = me.tileWidth / 8;

		//This will hold all of the tile sprites
		me.tiles = me.game.add.group();

		//Initialise tile grid, this array will hold the positions of the tiles
		//Create whatever shape you'd like
		me.tileGrid = [
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],

		];
		//Geogeeks

		this.level1 = [
			['q', 'u', 'i', 'c', 'k', 'c', 'a', 'p', 't', 'u', 'r', 'e', '', '', '', ''],
			['', '', '', '', '', '', '', '', '', '', '', 'x', '', '', '', ''],
			['a', 'r', 'c', 'g', 'i', 's', '', '', '', '', '', 'c', '', '', '', ''],
			['', '', '', '', 'o', '', '', '', '', '', '', 'a', '', 'i', '', ''],
			['', '', '', '', 'n', '', '', '', '', '', '', 'l', '', 'n', '', ''],
			['', '', 's', '', 'o', '', '', '', '', '', '', 'i', '', 'd', 't', ''],
			['e', '', 'e', '', 'g', '', '', '', '', '', 'd', 'b', '', 'o', 'r', ''],
			['c', 'i', 'n', 's', 'i', 'g', 'h', 't', 's', '', 'r', 'u', '', 'o', 'i', ''],
			['r', '', 'e', '', 'l', '', '', '', '', '', 'a', 'r', '', 'r', 'm', ''],
			['o', '', 'g', 'e', 'o', 'g', 'e', 'e', 'k', 's', 'o', 'a', '', 's', 'b', ''],
			['f', '', 'a', '', 'p', '', '', 'o', '', '', 'b', 'v', '', '', 'l', ''],
			['k', '', 'm', 'a', 'p', 'a', 'g', 'i', 's', '', 'h', 'r', '', '', 'e', ''],
			['r', '', 'i', '', '', '', '', '', '', '', 's', 'u', '', '', '', ''],
			['o', '', '', '', '', '', '', '', '', '', 'a', 'c', 'a', 'p', 'a', ''],
			['w', 'e', 'b', 'a', 'p', 'p', 'b', 'u', 'i', 'l', 'd', 'e', 'r', '', '', ''],
			['', 's', 't', 'o', 'r', 'y', 'm', 'a', 'p', '', '', '', '', '', '', '']
		];


		this.level2 = [
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['t', 'e', 'a', 't', 'r', 'o']
		];

		this.level3 = [
			['d', '', '', '', '', ''],
			['', 'a', '', '', '', ''],
			['', '', 'n', '', '', ''],
			['', '', '', 'z', '', ''],
			['', '', '', '', 'a', ''],
			['', '', '', '', '', '']
		];

		this.level4 = [
			['g', 'y', '', '', '', ''],
			['', 'm', '', '', '', ''],
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['', '', '', '', '', '']
		];

		this.level5 = [
			['', '', '', '', '', ''],
			['d', '', '', '', '', ''],
			['u', '', '', '', '', ''],
			['l', '', '', '', '', ''],
			['a', '', '', '', '', ''],
			['s', '', '', '', '', '']
		];

		this.level6 = [
			['', 'n', '', '', '', ''],
			['', 'o', '', '', '', ''],
			['', 'i', '', '', '', ''],
			['', 'c', '', '', '', ''],
			['', 'a', '', '', '', ''],
			['', 'e', 'r', 'c', 'e', 'r']
		];


		this.level9 = [
			['', '', '', '', 'e', 's'],
			['', '', '', '', 't', ''],
			['', '', '', '', 'r', ''],
			['', '', '', '', 'o', ''],
			['', '', 'd', 'e', 'p', ''],
			['', '', '', '', '', '']
		];

		this.level10 = [
			['', '', '', '', '', 'a'],
			['', '', '', '', '', 'i'],
			['', '', '', '', 'o', 'g'],
			['', '', '', 'o', 'l', ''],
			['', 'i', 'c', '', '', ''],
			['p', 's', '', '', '', '']
		];

		this.level11 = [
			['', '', '', '', '', ''],
			['', 'a', 'p', 'r', 'e', 'n'],
			['e', 'j', 'a', 'z', 'i', 'd'],
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['', '', '', '', '', '']
		];

		this.level12 = [
			['', '', '', '', '', 's'],
			['', '', '', '', '', 'e'],
			['', '', '', '', '', 'd'],
			['', '', '', '', '', 'a'],
			['', '', '', '', '', 'd'],
			['h', 'a', 'b', 'i', 'l', 'i']
		];

		this.level13 = [
			['', '', '', '', '', ''],
			['', 'p', '', '', '', ''],
			['', '', 'r', '', '', ''],
			['', '', '', 'o', '', 'o'],
			['', '', '', '', 'y', 't'],
			['', '', '', '', 'e', 'c']
		];

		this.level14 = [
			['', '', '', '', '', ''],
			['s', 'e', '', '', '', ''],
			['', 'r', 'v', '', '', ''],
			['', '', 'i', 'c', 'i', 'o'],
			['', '', '', '', '', ''],
			['', '', '', '', '', '']
		];

		this.level15 = [
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['', '', 'a', 'i', 'r', 'e'],
			['e', 'n', 'f', 'e', 'r', 'm'],
			['', '', '', '', '', '']
		];

		this.level16 = [
			['', '', '', '', '', 'c'],
			['', '', '', '', 'i', 'i'],
			['', '', '', 'r', 'o', ''],
			['', '', 't', 'n', '', ''],
			['', 'u', '', '', '', ''],
			['n', '', '', '', '', '']
		];

		this.level17 = [
			['', '', 's', 'e', '', ''],
			['', '', '', '', 't', ''],
			['', '', '', '', '', 'n'],
			['n', 'u', 't', 'r', 'i', 'e'],
			['', '', '', '', '', ''],
			['', '', '', '', '', '']
		];

		this.level18 = [
			['', '', '', '', '', ''],
			['', '', 'a', 'r', '', ''],
			['', '', 't', 'u', '', ''],
			['', '', 'l', 'u', '', ''],
			['', '', '', 'c', '', ''],
			['', '', '', '', '', '']
		];

		this.level19 = [
			['A', 'r', 't', 'e', '', ''],
			['', '', '', '', 't', ''],
			['', '', '', '', 'e', ''],
			['', '', '', '', 'r', ''],
			['', 'a', 'i', 'p', 'a', ''],
			['', '', '', '', '', '']
		];

		this.level20 = [
			['', '', '', '', '', ''],
			['', '', '', '', '', ''],
			['', 'p', 'r', 'e', '', ''],
			['', 'x', '', '', 's', ''],
			['', 'e', '', '', '', 'i'],
			['', '', '', '', 'n', 'o']
		];

		this.allLevels = [this.level1,this.level2,this.level3,this.level4,this.level5,this.level6,this.level9,this.level10,this.level11,this.level12,this.level13,this.level14,this.level15,this.level16,this.level17,this.level18,this.level19,this.level20]


		//Keep a reference to the total grid width and height
		me.boardWidth = me.tileGrid[0].length * me.tileWidth;
		me.boardHeight = me.tileGrid.length  * me.tileHeight;

		//We want to keep a buffer on the left and top so that the grid
		//can be centered
		me.leftBuffer = 60;
		me.topBuffer = (me.game.height - me.boardHeight) / 2;

		//Create a random data generator to use later
		var seed = Date.now();
		me.random = new Phaser.RandomDataGenerator([seed]);

		this.level = 0;


		//Set up some initial tiles and the score label
		me.initTiles();
		me.createScore();
		me.createTimer();

		me.game.input.onDown.add(function(){console.log('down' + me.guessing);me.guessing = true;}, me);
		me.game.input.onUp.add(function(){console.log('up '+ me.currentWord.length );me.guessing = false;}, me);

		me.gameTimer = game.time.events.loop(100, function(){
			me.updateTimer();
		});

		this.game.add.button(game.world.centerX - 400, 1200, 'button', this.changeBoard, this, 2, 1, 0);


		this.scoreAnimaText = '+0';


		this.scoreAnima = this.game.add.text(50, 50, "+20", {font: "35px Arial", fill: "#ff00ff"});
		this.scoreAnima.anchor.setTo(0.5, 0);
		this.scoreAnima.align = 'center';

		this.scoreAnima.x = 2000;

		this.scoreAnimaPos = 0;

		this.tweenscoreAnima;

	},

	update: function() {

		var me = this;

		if(me.scoreBuffer > 0){
			me.incrementScore();
			me.scoreBuffer--;
		}

		if(me.remainingTime < 1){
			//me.game.state.restart();
			score = me.score;
			me.game.state.start("GameOver");
		}

		//Get the location of where the pointer is currently
			var hoverX = me.game.input.x;
			var hoverY = me.game.input.y;

		if(me.guessing){


			//Figure out what position on the grid that translates to
			var hoverPosX = Math.floor((hoverX - me.leftBuffer)/me.tileWidth);
			var hoverPosY = Math.floor((hoverY - me.topBuffer)/me.tileHeight);

			//Check that we are within the game bounds
			if(hoverPosX >= 0 && hoverPosX < me.tileGrid[0].length && hoverPosY >= 0 && hoverPosY < me.tileGrid.length){

				//Grab the tile being hovered over
				var hoverTile = me.tileGrid[hoverPosX][hoverPosY];
				//console.log(hoverTile);

				//Figure out the bounds of the tile
				var tileLeftPosition = me.leftBuffer + (hoverPosX * me.tileWidth);
				var tileRightPosition = me.leftBuffer + (hoverPosX * me.tileWidth) + me.tileWidth;
				var tileTopPosition = me.topBuffer + (hoverPosY * me.tileHeight);
				var tileBottomPosition = me.topBuffer + (hoverPosY * me.tileHeight) + me.tileHeight;

				//If the player is hovering over the tile set it to be active. The buffer is provided here so that the tile is only selected
				//if the player is hovering near the center of the tile
				if(!hoverTile.isActive && hoverX > tileLeftPosition + me.selectBuffer && hoverX < tileRightPosition - me.selectBuffer
					&& hoverY > tileTopPosition + me.selectBuffer && hoverY < tileBottomPosition - me.selectBuffer){

					//Set the tile to be active
					hoverTile.isActive = true;

					hoverTile.alpha = 0.4;

					console.log(hoverTile.tileLetter);

					//Push this tile into the current word that is being built
					me.currentWord.push(hoverTile);
				}

			}

		}
		else {

			if(me.currentWord.length > 0){

				var guessedWord = '';

				//Build a string out of all of the active tiles
				for(var i = 0; i < me.currentWord.length; i++){
					guessedWord += me.currentWord[i].tileLetter;
					me.currentWord[i].isActive = false;
				}


				//Check to see if this word exists in our dictionary
				console.log(guessedWord);
				console.log(me.game.cache.getText('dictionary'))
				if(me.game.cache.getText('dictionary').indexOf(' ' + guessedWord + ' ') > -1 && guessedWord.length > 1){

					//Check to see that the word has not already been guessed
					if(me.correctWords.indexOf(guessedWord) == -1){

						//this.wordArray[0].alpha = 0.5;

						this.level ++;

						me.goodAnimation(hoverX,hoverY,10 * guessedWord.length);

						console.log(this.level);
						console.log(this.wordArray.length);

						if(me.scoreBuffer < 150){
							me.scoreBuffer += 1 * guessedWord.length;

						}else{
							me.scoreBuffer = 150;
						}


						//Add this word to the already guessed word
						me.correctWords.push(guessedWord);

						if(this.level >=  this.wordArray.length){
							console.log('termino');
							score = me.score;
							me.game.state.start("GameOver");

						}

						//me.ChangeTitle();
						//me.changeBoard();

					}else{
						me.BadAnimation(hoverX,hoverY,'Repetida');
						console.log("repetida");
						me.resetTitle();
					}

				}
				else {
					console.log("incorrect!");
					me.BadAnimation(hoverX,hoverY,'No');
					me.resetTitle();
				}

				//Reset the current word
				me.currentWord = [];

			}

		}

	},

	initTiles: function(){

		var me = this;

		//Loop through each column in the grid
		for(var i = 0; i < me.tileGrid.length; i++){

			//Loop through each position in a specific column, starting from the top
			for(var j = 0; j < me.tileGrid.length; j++){

				//Add the tile to the game at this grid position
				var tile = me.addTile(i, j);

				//Keep a track of the tiles position in our tileGrid
				me.tileGrid[i][j] = tile;

			}
		}

	},

	addTile: function(x, y){
		console.log(x + ' , ' + y);

		var me = this;

		var currentLevel = this.allLevels[this.level];

		//Choose a random tile to add
		var tileLetter;
		if (currentLevel [x][y] == ''){

			tileLetter = me.tileLetters[me.random.integerInRange(0, me.tileLetters.length - 1)];

		}else{
			tileLetter = currentLevel [x][y];
		}
		var tileColor = me.tileColors[me.random.integerInRange(0, me.tileColors.length - 1)];
		var tileToAdd = me.createTile(tileLetter, tileColor);

		//Add the tile at the correct x position, but add it to the top of the game (so we can slide it in)
		var tile = me.tiles.create(me.leftBuffer + (x * me.tileWidth) + me.tileWidth / 2, me.topBuffer + (y*me.tileHeight+(me.tileHeight/2)), tileToAdd);
		tile.scale.setTo(0, 0);

		//Animate the tile into the correct vertical position
		me.game.add.tween(tile.scale).to({x: 1, y: 1}, 500, Phaser.Easing.Bounce.Out, true)

		//Set the tiles anchor point to the center
		tile.anchor.setTo(0.5, 0.5);

		//Keep track of the type of tile that was added
		tile.tileLetter = tileLetter;

		return tile;

	},

	createTile: function(letter, color){

		var me = this;

		var tile = me.game.add.bitmapData(me.tileWidth, me.tileHeight);

		tile.ctx.rect(5, 5, me.tileWidth - 5, me.tileHeight - 5);
		tile.ctx.fillStyle = color;
		tile.ctx.fill();

		tile.ctx.font = '28px Arial';
		tile.ctx.textAlign = 'center';
		tile.ctx.textBaseline = 'middle';
		tile.ctx.fillStyle = '#fff';
		if(color == '#ffffff'){
			tile.ctx.fillStyle = '#000000';
		}
		tile.ctx.fillText(letter, (me.tileWidth / 2)+2, (me.tileHeight / 2)+2);
		return tile;

	},

	createScore: function(){

		var me = this;
		var scoreFont = "55px Arial";

		me.scoreLabel = me.game.add.text(765, 214 , "0", {font: scoreFont, fill: "#ffffff"});
		//me.scoreLabel.anchor.setTo(0.5, 0);
		//me.scoreLabel.align = 'center';

	},

	incrementScore: function(){

		var me = this;

		me.score += 1;
		me.scoreLabel.text = me.score;

	},

	createTimer: function(){

		var me = this;

		//me.timeBar = me.game.add.bitmapData(me.game.width, 50);

		//make white and have a blue background
		//me.timeBar.ctx.rect(0, 0, me.game.width, 50);
		//me.timeBar.ctx.fillStyle = '#ffffff';
		//me.timeBar.ctx.fill();

		//me.timeBar = me.game.add.sprite(0, 0, me.timeBar);
		//me.timeBar.cropEnabled = true;

	},

	updateTimer: function(){

		var me = this;

		me.remainingTime -= 10;

		tempTimer = Math.floor(me.remainingTime/100);

		timer.text = tempTimer +'seg';

		//var cropRect = new Phaser.Rectangle(0, 0, (me.remainingTime / me.fullTime) * me.game.width, me.timeBar.height);
		//me.timeBar.crop(cropRect);

	},

	ChangeTitle: function(){

		var me = this;

		for(var i = 0; i < me.currentWord.length; i++){
					var x = Math.floor((me.currentWord[i].x - me.leftBuffer)/me.tileWidth);
					var y = Math.floor((me.currentWord[i].y - me.topBuffer)/me.tileHeight)

					me.tileGrid[x][y] = me.addTile(x,y);;
					me.tiles.remove(me.currentWord[i]);
					me.currentWord[i].destroy();
				}

	},
	resetTitle: function(){
		var me = this;

		for(var i = 0; i < me.currentWord.length; i++){
			me.currentWord[i].alpha = 1;
		}

	},
	changeBoard: function(){
		var me = this;

		me.tiles.removeAll(true);
		me.tileGrid =  [
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
			[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]

		];
		me.initTiles();
	},

	goodAnimation: function(x,y,score){

		this.scoreAnima.addColor("#00ff00",0);

		this.scoreAnima.text = '+' + score;


		this.scoreAnima.alpha = 0;

		console.log(x);
		console.log(y);

		this.scoreAnima.x = x;
		this.scoreAnima.y = y

		this.scoreAnimaPos = y - 20;

		this.tweenscoreAnima = this.game.add.tween(this.scoreAnima).to( {y: this.scoreAnimaPos , alpha: 1}, 500, Phaser.Easing.Linear.None, true);

		this.tweenscoreAnima.onComplete.add(this.animaEnd, this);

	},
	animaEnd: function(scoreAnimaPos){
		this.game.add.tween(this.scoreAnima).to( {y: 10 - scoreAnimaPos, alpha: 0}, 100, Phaser.Easing.Linear.None, true);
	},
	BadAnimation: function(x,y,text){

		this.scoreAnima.addColor("#ff0000",0);

		this.scoreAnima.text = text;


		this.scoreAnima.alpha = 0;

		console.log(x);
		console.log(y);

		this.scoreAnima.x = x;
		this.scoreAnima.y = y

		this.scoreAnimaPos = y + 20;

		this.tweenscoreAnima = this.game.add.tween(this.scoreAnima).to( {y: this.scoreAnimaPos , alpha: 1}, 500, Phaser.Easing.Linear.None, true);

		this.tweenscoreAnima.onComplete.add(this.badanimaEnd, this);

	},
	badanimaEnd: function(scoreAnimaPos){
		this.game.add.tween(this.scoreAnima).to( {y: 10 + scoreAnimaPos, alpha: 0}, 100, Phaser.Easing.Linear.None, true);
	},

};